% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{topics_rake}
\alias{topics_rake}
\title{Keyword/Topic identification using RAKE}
\usage{
topics_rake(text, file = "english-ewt-ud-2.4-190531.udpipe", lang = "english")
}
\arguments{
\item{text}{Character vector}

\item{file}{Character. Name of \code{udpipe} model previously downloaded
for a specific language}

\item{lang}{Character. If file does not exist, this language will be
downloaded from \code{udpipe}'s models.}
}
\value{
data.frame with topics for each \code{text} input.
}
\description{
RAKE is a basic algorithm which tries to identify keywords in text.
Based on \code{udpipe} library, model models, and keywords_rake function.
}
\seealso{
Other Text Mining: 
\code{\link{cleanText}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()}
}
\concept{Text Mining}
