% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{what_size}
\alias{what_size}
\title{Calculate the size of any R object or directory}
\usage{
what_size(x = NULL, units = "Mb", path = NULL, recursive = TRUE, ...)
}
\arguments{
\item{x}{Object}

\item{units}{Character. Specify which unit to use,
i.e. "Gb", "Mb", "Kb".}

\item{path}{a character vector of full path names; the default
    corresponds to the working directory, \code{\link[base]{getwd}()}.  Tilde
    expansion (see \code{\link[base]{path.expand}}) is performed.  Missing
    values will be ignored.  Elements with a marked encoding will
    be converted to the native encoding (and if that fails, considered
    non-existent).}

\item{recursive}{logical.  Should the listing recurse into directories?}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Calculate the size of any R object or directory
}
\examples{
what_size(seq(1:1e3), "Kb")
what_size(seq(1:1e6))
what_size(as.character(seq(1:1e6)))
what_size(path = ".")
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{chr2num}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()}
}
\concept{Tools}
