% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robyn.R
\name{robyn_hypsbuilder}
\alias{robyn_hypsbuilder}
\title{Robyn: Generate default hyperparameters}
\usage{
robyn_hypsbuilder(
  channels,
  media_type = "default",
  adstock = "geometric",
  date_type = "weekly",
  lagged = FALSE
)
}
\arguments{
\item{channels}{Character vector. Paid media and organic variables names.}

\item{media_type}{Character vector. Must be length 1 or same as
\code{channels}. Pick, for every \code{channels} value,
what type of media it is: "online" or "offline".}

\item{adstock}{Character. Pick one of: "geometric" or "weibull".}

\item{date_type}{Character. Pick one of: "daily", "weekly", or "monthly".
Only valid to transform thetas when using geometric adstock. Set to "skip"
in case you wish to leave default weekly values.}

\item{lagged}{Boolean vector. Must be length 1 or same as
\code{channels}. Pick, for every \code{channels} value,
if you wish to have a lagged effect. Only valid for Weibull adstock.}
}
\value{
list with default hyperparameters ranges.
}
\description{
Generate a list with hyperparameter default values, ready to be
passed to \code{Robyn::robyn_inputs()}.
}
\examples{
robyn_hypsbuilder(
  channels = c(
    "branded_search_spend",
    "nonbranded_search_spend",
    "print_spend",
    "ooh_spend",
    "tv_spend",
    "radio_spend"
  ),
  media_type = c(
    "online", "online", "offline",
    "offline", "offline", "offline"
  ),
  adstock = "geometric",
  date_type = "weekly"
)
}
\seealso{
Other Robyn: 
\code{\link{robyn_marginal}()},
\code{\link{robyn_modelselector}()},
\code{\link{robyn_performance}()}
}
\concept{Robyn}
