% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{read.file}
\alias{read.file}
\title{Read Files Quickly (Auto-detected)}
\usage{
read.file(filename, current_wd = TRUE, sheet = 1, quiet = FALSE)
}
\arguments{
\item{filename}{Character. File name to import.}

\item{current_wd}{Boolean. Use current working directory before
the file's name? Use this param to NOT get absolute root directory.}

\item{sheet}{Character. Name or index of the sheet to read data
from if file is xlsx or xls.}

\item{quiet}{Boolean. Quiet summary message?}
}
\value{
List or data.frame, depending on \code{filename}'s data.
}
\description{
This function lets the user import csv, xlsx, xls, sav files.
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{chr2num}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{dont_sleep}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
