% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{as.document}
\alias{as.document}
\alias{as.document.character}
\alias{as.document.data.frame}
\title{Coerce to LaTeX Document}
\usage{
as.document(x, ...)

\method{as.document}{character}(
  x,
  preamble = makePreamble(...),
  thispagestyle = command("thispagestyle", args = "empty"),
  pagestyle = command("pagestyle", args = "empty"),
  prolog = NULL,
  epilog = NULL,
  ...
)

\method{as.document}{data.frame}(
  x,
  rules = c(2, 1, 1),
  walls = 0,
  grid = FALSE,
  rowgroups = factor(rownames(x)),
  colgroups = factor(names(x)),
  rowbreaks = if (grid) breaks(rowgroups, ...) else 0,
  colbreaks = if (grid) breaks(colgroups, ...) else 0,
  rowcolors = NULL,
  charjust = "left",
  numjust = "right",
  justify = ifelse(sapply(x, is.numeric), numjust, charjust),
  colwidth = NA,
  paralign = "top",
  na = "",
  verbatim = ifelse(sapply(x, is.numeric), TRUE, FALSE),
  escape = "#",
  reserve = TRUE,
  trim = TRUE,
  wide = NULL,
  long = NULL,
  wider = 0,
  longer = 0,
  ...
)
}
\arguments{
\item{x}{object to be converted, typically data.frame (paths of tex files for \code{tex2pdf} and \code{viewtex})}

\item{...}{passed to \code{\link{as.tabular.data.frame}} and \code{\link{as.document.character}}}

\item{preamble}{latex markup to include before beginning the document}

\item{thispagestyle}{thispagestyle command}

\item{pagestyle}{pagestyle command}

\item{prolog}{latex markup to include before x}

\item{epilog}{latex markup to include after x}

\item{rules}{numeric; will be recycled to length 3.  indicates number of horizontal lines above and below the header, and below the last row.}

\item{walls}{numeric, recycled to length 2.  Number of vertical lines on left and right of table.}

\item{grid}{logical, whether to have lines between rows and columns}

\item{rowgroups}{a vector as long as nrow(x), non-repeats trigger horizontal lines}

\item{colgroups}{a vector as long as names(x), non-repeats trigger vertical lines}

\item{rowbreaks}{numeric: a manual way to specify numbers of lines between rows (ignores grid and rowgroups)}

\item{colbreaks}{numeric: a manual way to specify numbers of lines between columns (ignores grid and colgroups)}

\item{rowcolors}{character vector of color names, recycled as necessary to color all rows (NULL: no color)}

\item{charjust}{default justification for character columns}

\item{numjust}{default justification for numeric columns}

\item{justify}{manual specification of column justifications: left, right, center, or decimal (vector as long as ncol(x))}

\item{colwidth}{manual specification of column width. (vector of length ncol(x).) Overrides \code{justify where not NA.}}

\item{paralign}{used with colwidth to align paragraphs: top, middle, or bottom.}

\item{na}{string to replace NA elements}

\item{verbatim}{whether to use verbatim environment for numeric fields.  Makes sense for decimal justification; interacts with \code{trim} and \code{justify}.}

\item{escape}{symbol used by `verb' command as delimiter.  A warning is issued if it is found in non-NA text.}

\item{reserve}{substitute escape sequences for LaTeX \href{https://en.wikibooks.org/wiki/LaTeX/Basics#Reserved_Characters}{reserved} characters}

\item{trim}{passed to the format command: true by default, so that alignment is the responsibility of just the tabular environment arguments}

\item{wide}{nominal page width in mm}

\item{long}{nominal page length in mm}

\item{wider}{additional page width in mm}

\item{longer}{additional page lenth in mm}
}
\value{
character

character

character
}
\description{
Coerces to LaTeX document.  Generic, with methods for character and data.frame.

Coerces to LaTex document from character.

Coerces to LaTeX document from data.frame.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: character method

\item \code{data.frame}: data.frame method
}}

\examples{
as.document(head(Theoph))
}
\seealso{
\code{\link{as.tabular.data.frame}}

\code{\link{as.document.character}}

\code{\link{as.pdf.data.frame}}
}
