% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodMclustLLPA.R
\name{lcMethodMclustLLPA}
\alias{lcMethodMclustLLPA}
\title{Longitudinal latent profile analysis}
\usage{
lcMethodMclustLLPA(
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{...}{Arguments passed to \link[mclust:Mclust]{mclust::Mclust}.
The following external arguments are ignored: data, G, verbose.}
}
\description{
Latent profile analysis or finite Gaussian mixture modeling.
}
\examples{
library(mclust)
data(latrendData)
method <- lcMethodMclustLLPA("Y", id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAKMedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}},
\code{\link{lcMethodTwoStep}}
}
\concept{lcMethod implementations}
