% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodMixtoolsNPRM.R
\name{lcMethodMixtoolsNPRM}
\alias{lcMethodMixtoolsNPRM}
\title{Specify non-parametric estimation for independent repeated measures}
\usage{
lcMethodMixtoolsNPRM(
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  blockid = NULL,
  bw = NULL,
  h = NULL,
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{blockid}{See \link[mixtools:npEM]{mixtools::npEM}.}

\item{bw}{See \link[mixtools:npEM]{mixtools::npEM}.}

\item{h}{See \link[mixtools:npEM]{mixtools::npEM}.}

\item{...}{Arguments passed to \link[mixtools:npEM]{mixtools::npEM}.
The following optional arguments are ignored: data, x, mu0, verb.}
}
\description{
Specify non-parametric estimation for independent repeated measures
}
\examples{
library(mixtools)
data(latrendData)
method <- lcMethodMixtoolsNPRM("Y", id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
}
\references{
\insertRef{benaglia2009mixtools}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
