% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict.lcModel}
\alias{predict.lcModel}
\title{lcModel predictions}
\usage{
\method{predict}{lcModel}(object, newdata = NULL, what = "mu", ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{newdata}{Optional \code{data.frame} for which to compute the model predictions. If omitted, the model training data is used.
Cluster trajectory predictions are made when ids are not specified.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{...}{Additional arguments.}
}
\value{
If \code{newdata} specifies the cluster membership; a \code{data.frame} of cluster-specific predictions. Otherwise, a \code{list} of \code{data.frame} of cluster-specific predictions is returned.
}
\description{
Predicts the expected trajectory observations at the given time for each cluster.
}
\details{
Subclasses of \code{lcModel} should preferably implement \code{predictForCluster} instead of overriding \code{predict.lcModel} in order to benefit from standardized error checking and output handling.
}
\examples{
data(latrendData)
model <- latrend(lcMethodLcmmGMM(
   fixed = Y ~ Time, mixture = ~ Time,
   id = "Id", time = "Time"), latrendData)
predFitted <- predict(model) # same result as fitted(model)

# Cluster trajectory of cluster A
predCluster <- predict(model, newdata = data.frame(Cluster = "A", Time = time(model)))

# Prediction for id S1 given cluster A membership
predId <- predict(model, newdata = data.frame(Cluster = "A", Id = "S1", Time = time(model)))

# Prediction matrix for id S1 for all clusters
predIdAll <- predict(model, newdata = data.frame(Id = "S1", Time = time(model)))
}
\seealso{
Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()},
\code{\link{trajectories}()}
}
\concept{model-specific methods}
