% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{lcMethod.call}
\alias{lcMethod.call}
\title{Create a lcMethod object from a call}
\usage{
lcMethod.call(Class, call, defaults = list(), excludeArgs = c())
}
\arguments{
\item{Class}{The type of \link{lcMethod} class}

\item{call}{The arguments to create the \code{lcMethod} from.}

\item{defaults}{List of \code{function} to obtain defaults from for arguments not defined in \code{call}.}

\item{excludeArgs}{The names of the arguments to exclude from the defaults, provided as a \verb{character vector}.}
}
\value{
An object of class \code{Class} that extends \code{lcMethod}.
}
\description{
Creates a lcMethod class of the specified type \code{Class} for the given arguments given in a call, along with any default arguments from reference functions.
This function is intended to be used by classes extending \code{lcMethod} to provide an easy way to construct the appropriate \code{call} object.
}
\examples{
data(latrendData)
lcMethodKML2 <- function(response = "Y", id = "Id", time = "Time", nClusters = 2, ...) {
  lcMethod.call("lcMethodKML", call = stackoverflow::match.call.defaults(),
    defaults = c(kml::kml, kml::parALGO),
    excludeArgs = c("object", "nbClusters", "parAlgo", "toPlot", "saveFreq"))
}
method <- lcMethodKML2(nClusters = 3)
latrend(method, data = latrendData)
}
\seealso{
\link{lcMethod}
}
