% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodLongclust.R
\name{lcMethodLongclust}
\alias{lcMethodLongclust}
\title{Specify Longclust method}
\usage{
lcMethodLongclust(
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{...}{Arguments passed to \link[longclust:longclustEM]{longclust::longclustEM}.
The following external arguments are ignored: data, x, Gmin, Gmax, userseed.}
}
\description{
Specify Longclust method
}
\examples{
library(longclust)
data(latrendData)
method <- lcMethodLongclust("Y", id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
}
\references{
\insertRef{mcnicholas2019longclust}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
