% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\docType{class}
\name{lcModel-class}
\alias{lcModel-class}
\alias{getLabel,lcModel-method}
\alias{getName,lcModel-method}
\alias{getShortName,lcModel-method}
\title{lcModel class}
\usage{
\S4method{getLabel}{lcModel}(object, ...)

\S4method{getName}{lcModel}(object)

\S4method{getShortName}{lcModel}(object)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{Any additional arguments.}
}
\description{
Abstract class for defining estimated longitudinal cluster models.

Extracts the name of the \code{lcModel} object.
The name is comprised of the underlying \code{lcMethod} name, and the assigned label (if any).
}
\details{
An extending class must implement the following methods to ensure basic functionality:
\itemize{
\item \code{predict.lcModelExt}: Used to obtain the fitted cluster trajectories and trajectories.
\item \code{postprob(lcModelExt)}: The posterior probability matrix is used to determine the cluster assignments of the trajectories.
}

For predicting the posterior probability for unseen data, the \code{predictPostprob()} should be implemented.
}
\section{Slots}{

\describe{
\item{\code{method}}{The \link{lcMethod-class} object specifying the arguments under which the model was fitted.}

\item{\code{call}}{The \code{call} that was used to create this \code{lcModel} object. Typically, this is the call to \code{latrend()} or any of the other fitting functions.}

\item{\code{model}}{An arbitrary underlying model representation.}

\item{\code{data}}{A \code{data.frame} object, or an expression to resolves to the \code{data.frame} object.}

\item{\code{date}}{The date-time when the model estimation was initiated.}

\item{\code{id}}{The name of the trajectory identifier column.}

\item{\code{time}}{The name of the time variable.}

\item{\code{response}}{The name of the response variable.}

\item{\code{label}}{The label assigned to this model.}

\item{\code{ids}}{The possible trajectory identifier values the model was fitted on.}

\item{\code{clusterNames}}{The names of the clusters.}

\item{\code{estimationTime}}{The time, in seconds, that it took to fit the model.}

\item{\code{tag}}{An arbitrary user-specified data structure. This slot may be accessed and updated directly.}
}}

\seealso{
Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()},
\code{\link{trajectories}()}
}
\concept{model-specific methods}
