% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R, R/metrics.R, R/models.R
\name{metric}
\alias{metric}
\alias{metric,lcModel-method}
\alias{metric,list-method}
\alias{metric,lcModels-method}
\title{Compute internal model metric(s)}
\usage{
\S4method{metric}{lcModel}(object, name = c("AIC", "BIC", "WRSS", "APPA"), ...)

\S4method{metric}{list}(object, name, drop = TRUE)

\S4method{metric}{lcModels}(object, name, drop = TRUE)
}
\arguments{
\item{object}{The \code{lcModel}, \code{lcModels}, or \code{list} of \code{lcModel} objects to compute the metrics for.}

\item{name}{The name(s) of the metric(s) to compute.}

\item{...}{Additional arguments.}

\item{drop}{Whether to return a \verb{numeric vector} instead of a \code{data.frame}
in case of a single metric.}
}
\value{
For \code{metric(lcModel)}: A named \code{numeric} vector with the computed model metrics.

For \code{metric(list)}: A \code{data.frame} with a metric per column.

For \code{metric(lcModels)}: A \code{data.frame} with a metric per column.
}
\description{
Compute internal model metric(s)
}
\examples{
data(latrendData)
model <- latrend(lcMethodLcmmGMM(fixed = Y ~ Time, mixture = ~ Time,
   id = "Id", time = "Time"), latrendData)
bic <- metric(model, "BIC")

ic <- metric(model, c("AIC", "BIC"))
}
\seealso{
\link{externalMetric} \link{min.lcModels} \link{max.lcModels}

Other metric functions: 
\code{\link{defineExternalMetric}()},
\code{\link{defineInternalMetric}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{getExternalMetricDefinition}()},
\code{\link{getExternalMetricNames}()},
\code{\link{getInternalMetricDefinition}()},
\code{\link{getInternalMetricNames}()}
}
\concept{metric functions}
