% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{subset.lcModels}
\alias{subset.lcModels}
\title{Subsetting a lcModels list based on method arguments}
\usage{
\method{subset}{lcModels}(x, subset, drop = FALSE, ...)
}
\arguments{
\item{x}{The \code{lcModels} or list of \code{lcModel} to be subsetted.}

\item{subset}{Logical expression based on the \code{lcModel} method arguments, indicating
which \code{lcModel} objects to keep.}

\item{drop}{Whether to return a \code{lcModel} object if the result is length 1.}

\item{...}{Not used.}
}
\value{
A \code{lcModels} list with the subset of \code{lcModel} objects.
}
\description{
Subsetting a lcModels list based on method arguments
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")

model1 <- latrend(method, latrendData, nClusters = 1)
model2 <- latrend(method, latrendData, nClusters = 2)
model3 <- latrend(method, latrendData, nClusters = 3)

rngMethod <- lcMethodRandom("Y", id = "Id", time = "Time")
rngModel <- latrend(rngMethod, latrendData)

models <- lcModels(model1, model2, model3, rngModel)

subset(models, nClusters > 1 & .method == 'lmkm')
}
\seealso{
Other lcModel list functions: 
\code{\link{as.lcModels}()},
\code{\link{lcModels}},
\code{\link{print.lcModels}()}
}
\concept{lcModel list functions}
