% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.default.R
\name{density.sim}
\alias{density.sim}
\alias{plot.sim}
\title{Plot sim object}
\usage{
\method{density}{sim}(x, ..., plot.type = "single")
}
\arguments{
\item{x}{sim object}

\item{...}{Graphical arguments to plot.sim}

\item{plot.type}{Single or multiple plots}
}
\description{
Plot sim object
}
\examples{
n <- 1000
val <- cbind(est1=rnorm(n,sd=1),est2=rnorm(n,sd=0.2),est3=rnorm(n,1,sd=0.5),
             sd1=runif(n,0.8,1.2),sd2=runif(n,0.1,0.3),sd3=runif(n,0.25,0.75))
plot.sim(val,estimate=c(1,2),true=c(0,0),se=c(4,5),equal=TRUE)
plot.sim(val,estimate=c(1,3),true=c(0,1),se=c(4,6),density.xlim=c(-3,3),ylim=c(-3,3))
plot.sim(val,estimate=c(1,2),true=c(0,0),se=c(4,5),equal=TRUE,plot.type="single")
plot.sim(val,estimate=c(1),se=c(4,5,6),plot.type="single")
plot.sim(val,estimate=c(1,2,3),equal=TRUE)
plot.sim(val,estimate=c(1,2,3),equal=TRUE,byrow=TRUE)
plot.sim(val,estimate=c(1,2,3),plot.type="single")
plot.sim(val,estimate=1,se=c(3,4,5),plot.type="single")
density.sim(val,estimate=c(1,2,3),polygon.density=c(0,10,10),polygon.angle=c(0,45,-45))
}

