% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsearch.R
\name{modelsearch}
\alias{modelsearch}
\title{Model searching}
\usage{
modelsearch(x, k = 1, dir = "forward", type = "all", ...)
}
\arguments{
\item{x}{\code{lvmfit}-object}

\item{k}{Number of parameters to test simultaneously. For \code{equivalence}
the number of additional associations to be added instead of \code{rel}.}

\item{dir}{Direction to do model search. "forward" := add
associations/arrows to model/graph (score tests), "backward" := remove
associations/arrows from model/graph (wald test)}

\item{type}{If equal to 'correlation' only consider score tests for covariance parameters. If equal to 'regression' go through direct effects only  (default 'all' is to do both)}

\item{...}{Additional arguments to be passed to the low level functions}
}
\value{
Matrix of test-statistics and p-values
}
\description{
Performs Wald or score tests
}
\examples{

m <- lvm();
regression(m) <- c(y1,y2,y3) ~ eta; latent(m) <- ~eta
regression(m) <- eta ~ x
m0 <- m; regression(m0) <- y2 ~ x
dd <- sim(m0,100)[,manifest(m0)]
e <- estimate(m,dd);
modelsearch(e,silent=TRUE)
modelsearch(e,silent=TRUE,type="cor")
}
\seealso{
\code{\link{compare}}, \code{\link{equivalence}}
}
\author{
Klaus K. Holst
}
\keyword{htest}
