% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Cross-validation}
\usage{
cv(modelList, data, K = 5, rep = 1, perf, seed = NULL, mc.cores = 1,
  shared = NULL, ...)
}
\arguments{
\item{modelList}{List of fitting functions or models}

\item{data}{data.frame}

\item{K}{Number of folds (default 5, 0 splits in 1:n/2, n/2:n with last part used for testing)}

\item{rep}{Number of repetitions (default 1)}

\item{perf}{Performance measure (default RMSE)}

\item{seed}{Optional random seed}

\item{mc.cores}{Number of cores used for parallel computations}

\item{shared}{function applied to each fold with results send to each model}

\item{...}{Additional arguments parsed to models in modelList and perf}
}
\description{
Cross-validation
}
\details{
Generic cross-validation function
}
\examples{
f0 <- function(data,...) lm(...,data)
f1 <- function(data,...) lm(Sepal.Length~Species,data)
f2 <- function(data,...) lm(Sepal.Length~Species+Petal.Length,data)
x <- cv(list(m0=f0,m1=f1,m2=f2),rep=10, data=iris, formula=Sepal.Length~.)
x2 <- cv(list(f0(iris),f1(iris),f2(iris)),rep=10, data=iris)
}
\author{
Klaus K. Holst
}
