% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_defined.R
\name{lavaan_defined}
\alias{lavaan_defined}
\alias{lavaan_ind}
\title{Extract relevant user-defined parameter (e.g., indirect or total
effects) indices from lavaan model}
\usage{
lavaan_defined(
  fit,
  underscores_to_symbol = "→",
  lhs_name = "User-Defined Parameter",
  rhs_name = "Paths",
  nice_table = FALSE,
  ...
)
}
\arguments{
\item{fit}{lavaan fit object to extract fit indices from}

\item{underscores_to_symbol}{Character to convert underscores
to arrows in the first column, like for indirect effects. Default to
the right arrow symbol, but can be set to NULL or "_", or to any
other desired  symbol. It is also possible to provide a vector of
replacements if they they are not all the same.}

\item{lhs_name}{Name of first column, referring to the left-hand side
expression (lhs).}

\item{rhs_name}{Name of first column, referring to the right-hand side
expression (rhs).}

\item{nice_table}{Logical, whether to print the table as a
\link[rempsyc:nice_table]{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{...}{Arguments to be passed to \link[rempsyc:nice_table]{rempsyc::nice_table}}
}
\value{
A dataframe, including the indirect effect ("lhs"),
corresponding paths ("rhs"), standardized regression
coefficient ("std.all"), corresponding p-value, as well
as the unstandardized regression coefficient ("est") and
its confidence interval ("ci.lower", "ci.upper").
}
\description{
Extract relevant user-defined parameters (e.g., indirect or
total effects) indices from lavaan model through
\link[lavaan:parameterEstimates]{lavaan::parameterEstimates} and \link[lavaan:standardizedSolution]{lavaan::standardizedsolution}.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

(mediation <- list(
  speed = "visual",
  textual = "visual",
  visual = c("ageyr", "grade")
))

(indirect <- list(
  IV = c("ageyr", "grade"),
  M = "visual",
  DV = c("speed", "textual")
))

HS.model <- write_lavaan(mediation,
  indirect = indirect,
  latent = latent, label = TRUE
)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data = HolzingerSwineford1939)
lavaan_defined(fit, lhs_name = "Indirect Effect")
\dontshow{\}) # examplesIf}
}
