% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{lawn_nearest}
\alias{lawn_nearest}
\title{Get nearest point}
\usage{
lawn_nearest(point, against, lint = FALSE)
}
\arguments{
\item{point}{The reference point, a \code{\link{data-Feature}}}

\item{against}{Input point set, a \code{\link{data-FeatureCollection}}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
A \code{\link{data-Point}} as a Feature
}
\description{
Takes a reference \code{\link{data-Point}} and a set of points and returns the point from
the set closest to the reference
}
\examples{
point <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#0f0"
  },
  "geometry": {
    "type": "Point",
    "coordinates": [28.965797, 41.010086]
  }
}'
against <- '{
 "type": "FeatureCollection",
 "features": [
   {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [28.973865, 41.011122]
     }
   }, {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [28.948459, 41.024204]
     }
   }, {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [28.938674, 41.013324]
     }
   }
 ]
}'
lawn_nearest(point, against)

}
\seealso{
Other classification: \code{\link{lawn_jenks}},
  \code{\link{lawn_quantile}}, \code{\link{lawn_reclass}}
}

