% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{lawn_size}
\alias{lawn_size}
\title{Expand a bounding box}
\usage{
lawn_size(bbox, factor)
}
\arguments{
\item{bbox}{a bounding box}

\item{factor}{the ratio of the new bbox to the input bbox}
}
\value{
the resized bbox, numeric vector of length four
}
\description{
Takes a bounding box and returns a new bounding box with a size
expanded or contracted by a factor of X.
}
\examples{
bbox <- c(0, 0, 10, 10)
lawn_size(bbox, factor = 1)
lawn_size(bbox, factor = 10)
lawn_size(bbox, factor = 50)
lawn_size(bbox, factor = 100)
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bearing}}, \code{\link{lawn_center}},
  \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_square}}
}

