% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.test.R
\name{symmetry.test}
\alias{symmetry.test}
\title{Test of Symmetry}
\usage{
symmetry.test(x, option = c("MGG", "CM", "M"), side = c("both", "left",
  "right"), boot = TRUE, B = 1000, q = 8/9)
}
\arguments{
\item{x}{data to be tested for symmetry.}

\item{option}{test statistic to be applied. The options include statistic by 
\insertCite{Miao_etal_2006;textual}{lawstat} (default),
\insertCite{Cabilio_Masaro_1996;textual}{lawstat}, 
and \insertCite{Mira_1999;textual}{lawstat}.}

\item{side}{choice from the three possible alternative hypotheses: 
general distribution asymmetry (\code{side = "both"}, default), 
left skewness (\code{side = "left"}), or right skewness (\code{side = "right"}).}

\item{boot}{logical value indicates whether \eqn{m}-out-of-\eqn{n} bootstrap will 
be used to obtain critical values (default), 
or asymptotic distribution of the chosen statistic.}

\item{B}{number of bootstrap replications to perform (default is 1000).}

\item{q}{scalar from 0 to 1 to define a set of possible \eqn{m} for the 
\eqn{m}-out-of-\eqn{n} bootstrap. Default \code{q = 8/9}. 
Possible \eqn{m} are then set as the values \code{unique(round(n*(q^j))} 
greater than 4, where \code{n = length(x)} and \code{j = c(0:20)}.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{method}{name of the method.}
\item{data.name}{name of the data.}
\item{statistic}{value of the test statistic.}
\item{p.value}{\eqn{p}-value of the test.}
\item{alternative}{alternative hypothesis.}
\item{estimate}{bootstrap optimal \eqn{m} (given in the output only if bootstrap 
was used, i.e., \code{boot = TRUE}).}
}
\description{
Perform test for symmetry about an unknown median. Users can choose among the 
Cabilio--Masaro test \insertCite{Cabilio_Masaro_1996}{lawstat},
the Mira test \insertCite{Mira_1999}{lawstat}, 
or the MGG test \insertCite{Miao_etal_2006}{lawstat}; 
and between using asymptotic distribution of the respective statistics or 
a distribution from \eqn{m}-out-of-\eqn{n} bootstrap 
\insertCite{Lyubchich_etal_2016_symmetry}{lawstat}.
Additionally to the general distribution asymmetry, the function allows to test 
for negative or positive skeweness (see the argument \code{side}). 
\code{NA}s from the data are omitted.
}
\details{
If the bootstrap option is used (\code{boot = TRUE}), a bootstrap 
distribution is obtained for each candidate subsample size \eqn{m}. Then, a heuristic 
method \insertCite{Bickel_etal_1997,Bickel_Sakov_2008}{lawstat}
is used for the choice of optimal \eqn{m}. Specifically, we use the Wasserstein metric 
\insertCite{Ruschendorf_2001}{lawstat} to calculate distances between different 
bootstrap distributions and select \eqn{m}, which corresponds to the minimal distance. 
See \insertCite{Lyubchich_etal_2016_symmetry;textual}{lawstat} for more details.
}
\examples{
data(zuni) #run ?zuni to see the data description
symmetry.test(zuni[,"Revenue"], boot = FALSE)

}
\references{
\insertAllCited{}
}
\author{
Joseph L. Gastwirth, Yulia R. Gel, Wallace Hui, Vyacheslav Lyubchich, 
Weiwen Miao, Xingyu Wang (in alphabetical order)
}
\keyword{distribution}
\keyword{htest}
\keyword{robust}
