\name{lazy.figure}
\alias{lazy.figure}
\title{Include Figures in Latex Documents}
\description{Generates the code to place a figure in a Latex document}

\usage{
lazy.figure(filename, caption = NULL, 
  align = "center", height = 3, width = 3, units = "in", 
  counter, counterSet = NULL, 
  label = NULL, placement = "!H")
}

\arguments{
  \item{filename}{Character string giving the location of the file to be 
    included.}
  \item{caption}{Text giving the caption for the figure}
  \item{align}{Character string stating the alignment.  Valid options are
    \code{"left"}, \code{"right"}, or \code{"center"}.}
  \item{height}{The height of the figure}
  \item{width}{The width of the figure}
  \item{units}{The units for height and width.  Defaults to \code{"in"}.}
  \item{counter}{Name of a counter to use to number the table.}
  \item{counterSet}{The number to which \code{counter} should be set.  In other words, the figure number for this figure.}
  \item{label}{Name of a label}
  \item{placement}{Controls the placement of the figure.  Options are
    \code{"ht", "t", "b", "p", "H"} and can be supplemented with 
    \code{"!"}. See "Details" for more explanation.}
}
\details{
  \code{placement} options are used as follows:
    \tabular{ll}{
      ht \tab Place the float here, i.e., 
              approximately at the same point it occurs \cr
      t  \tab Position at the top of the page\cr
      b  \tab Position at the bottom of the page \cr
      p  \tab Put on a special page for floats only \cr
      H  \tab Places the float at precisely the location in the LaTeX code. 
              Requires the float package\cr
    }
  The \code{"!"} may be used after any of these in order to override 
  LaTeX float rules and force your selection.  More can be learned by 
  reading about floats in a LaTeX manual.
}

\author{Benjamin Nutter \email{nutterb@ccf.org}}

\examples{
pdf("MPG.pdf", height=4, width=4)
  hist(mtcars$mpg)
dev.off()

lazy.figure("MPG.pdf")
    
lazy.write(
  lazy.file.start(),
  lazy.figure("MPG.pdf", 
      caption="Distribution of Miles per Gallon in mtcars dataset",
      height=5, width=5, label="MPGgraph"),
  lazy.file.end(),
  OutFile="Example 1.tex")
  
unlink("Example 1.tex")
}

\keyword{ methods }

