% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.lcmm}
\alias{simulate.lcmm}
\title{Data simulation according to models from lcmm package}
\usage{
\method{simulate}{lcmm}(
  object,
  nsim,
  seed,
  times,
  tname = NULL,
  n,
  Xbin = NULL,
  Xcont = NULL,
  entry = 0,
  dropout = NULL,
  pMCAR = 0,
  ...
)
}
\arguments{
\item{object}{an object of class \code{hlme}, \code{lcmm}, \code{multlcmm} or
\code{Jointlcmm}}

\item{nsim}{not used (for compatibility with stats::simulate). The function simulates only one sample}

\item{seed}{the random seed}

\item{times}{either a data frame with 2 columns containing IDs and measurement times, or a vector of length 4 specifying the minimal and maximum measurement times, the spacing between 2 consecutive visits and the margin around this spacing}

\item{tname}{the name of the variable representing the measurement times in \code{object}.
Default to the second column's name of times if it is a data frame, and to object$var.time otherwise.}

\item{n}{number of subjects to simulate. Required only if times is not a data frame.}

\item{Xbin}{an optional named list giving the probabilities of the binary
covariates to simulate. The list's names should match the binary covariate's names
used in \code{object}.}

\item{Xcont}{an optional named list giving the mean and standard deviation
of the Gaussian covariates to simulate. The list's names should match the
continuous covariate's names used in \code{object}.}

\item{entry}{expression to simulate a subject's entry time. Default to 0.}

\item{dropout}{expression to simulate a subject's time to dropout. Default to NULL,
no dropout is considered.}

\item{pMCAR}{optional numeric giving an observation's probability to be missing.
Default to 0, no missing data are introduced.}

\item{\dots}{additionnal options. None is used yet.}
}
\value{
a data frame with one line per observation and one column per variable. Variables appears in the following order : subject id, measurement time, entry time, binary covariates, continuous covariates, longitudinal outcomes, latent class, entry time, survival time, event indicator.
}
\description{
This function simulates a sample according to a model estimated with \code{hlme},
\code{lcmm}, \code{multlcmm} or \code{Jointlcmm} functions.
}
\examples{
## estimation of a 2 classes mixed model
m2 <- hlme(Y~Time*X1,mixture=~Time,random=~Time,classmb=~X2+X3,subject='ID',
         ng=2,data=data_hlme,B=c(0.11,-0.74,-0.07,20.71,
                                 29.39,-1,0.13,2.45,-0.29,4.5,0.36,0.79,0.97))

## simulate according to model m2 with same number of subjects and
## same measurement times as in data_lcmm. Binary covariates X1 and X2 are simulated
## according to a Bernoulli distribution with probability p=0.5, continuous covariate
## X3 is simulated according to a Gaussian distribution with mean=1 and sd=1 :
dsim1 <- simulate(m2, times=data_hlme[,c("ID","Time")],
                  Xbin=list(X1=0.5, X2=0.5), Xcont=list(X3=c(1,1)))

## simulate a dataset of 300 subjects according to the same model
## with new observation times, equally spaced and ranging from 0 to 3 :
dsim2 <- simulate(m2, times=c(0,3,0.5,0), n=300, tname="Time",
                  Xbin=list(X1=0.5, X2=0.5), Xcont=list(X3=c(1,1)))



}
\author{
Viviane Philipps and Cecile Proust-Lima
}
