% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-ts_log_rtn.R
\name{ldhmm.ts_log_rtn}
\alias{ldhmm.ts_log_rtn}
\title{Get log-returns from historic prices of an index}
\usage{
ldhmm.ts_log_rtn(symbol = "spx", start.date = "1950-01-01",
  end.date = "2015-12-31", on = "weeks", fred.data = FALSE)
}
\arguments{
\item{symbol}{character, specify the symbol of the index, default is \code{spx}.}

\item{start.date, end.date}{Date or character of ISO format (YYYY-MM-DD), to specify the date range, 
default is from 1950-01-01 to 2016-12-31. 
Set start.date and end.date to NULL or "" if you wish to get the entire time series.}

\item{on}{character, specify the interval, days, weeks, months. Default is \code{weeks}.}

\item{fred.data}{logical, specify whether to append daily time series data from FRED, default is \code{FALSE}.}
}
\value{
list of three vectors: \code{d} is the dates and \code{x} is log-returns and \code{p} is prices
}
\description{
This utility returns the dates and log-returns of an index available in ecd package.
Note that the data from ecd package is static. A limited set of live daily time series can be appended 
from FRED, e.g. SPX, VIX, DJIA.
}
\examples{
a <- ldhmm.ts_log_rtn()
}
\author{
Stephen H. Lihn
}
\keyword{data}
