% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-oxford_man_realized_data.R
\name{ldhmm.oxford_man_realized_data}
\alias{ldhmm.oxford_man_realized_data}
\title{Get the realized data from Oxford-Man}
\usage{
ldhmm.oxford_man_realized_data(force = FALSE, debug = FALSE)
}
\arguments{
\item{force}{logical, force the utility to fetch the new file. Default is \code{FALSE}.}

\item{debug}{logical, print debug information. Could be very verbose. Default is \code{FALSE}.}
}
\value{
data.frame containing the raw data from Oxford-Man.
}
\description{
This utility fetches the realized data from Oxford-Man and stores the data frame in local memory.
It can be retrieved as \code{getOption("ldhmm.oxford.rv")}. Since the data is updated on a daily basis.
The user can optionally force the utility to fetch the new file in the same R-session.
Note that the download is network intensive. The size of file is about 10-20 MB and growing daily.
In addition, VIX daily data is downloaded as \code{getOption("ldhmm.oxford.vix")}.
}
\examples{
\dontrun{
    ldhmm.oxford_man_realized_data()
}
}
\references{
Oxford-Man Institute of Quantitative Finance. Realized Library: http://realized.oxford-man.ox.ac.uk
}
\author{
Stephen H. Lihn
}
\keyword{oxford}
