% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sur.R
\name{SurSearch_s}
\alias{SurSearch_s}
\title{Step-wise SUR Search}
\usage{
SurSearch_s(
  x,
  xSizes = list(c(1, 2), c(3, 4), c(5), c(6:10)),
  counts = c(NA, 40, 30, 20),
  savePre = NULL,
  ...
)
}
\arguments{
\item{x}{exogenous data}

\item{xSizes}{a list of model dimension to be estimated in each step.}

\item{counts}{a list of suggested number of variables to be used
in each step. \code{NA} means all variables. Variables are selected
based on best estimations (select an appropriate value for
\code{searchItems$bestK}). All variables in the best models (all measures
and targets) are selected until corresponding suggested number is reached.}

\item{savePre}{if not \code{NULL}, it saves and tries to load the progress
of search step in a file (name=\code{paste0(savePre,i)} where \code{i}
is the index of the step).}

\item{...}{other arguments to pass to \code{\link[=SurSearch]{SurSearch()}} function such
as endogenous data. Note that \code{xSizes} is treated differently.}
}
\value{
A combined \code{LdtSearch} object
}
\description{
A helper class to deal with large model sets.
It selects a subset of variables from smaller models and
moves to the bigger ones.
}
