% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{eqList2Matrix}
\alias{eqList2Matrix}
\title{Convert a List of Equations to a Matrix}
\usage{
eqList2Matrix(equations, data, addIntercept = FALSE)
}
\arguments{
\item{equations}{A formula or a list of formula objects representing the equations.}

\item{data}{A matrix or a data frame containing the variables in the equations.}

\item{addIntercept}{Logical. If \code{TRUE}, an intercept column is added after the response variables. Default is \code{FALSE}.}
}
\value{
\item{result}{A matrix with response variables in the first columns, predictor variables in subsequent columns, and optionally an intercept column. The matrix does not contain duplicate columns.}
\item{numResponse}{Number of response variables in the first columns.}
}
\description{
This function takes a list of equations and a data frame, and returns a matrix where the response variables are in the first columns, and the predictor variables are in the subsequent columns.
}
\details{
The function checks for duplicate response variables across equations and throws an error if any are found. It also ensures that predictor variables are not duplicated in the final matrix.
}
\examples{
data <- data.frame(income = c(50000, 60000, 80000, 85000, 65000),
                   age = c(25, 32, 47, 51, 36),
                   education = c(16, 18, 20, 20, 16),
                   savings = c(20000, 25000, 30000, 35000, 40000))
equations <- list(as.formula("income ~ age + education"),
                  as.formula("savings ~ age + education"))
matrix_data <- ldt:::eqList2Matrix(equations, data, addIntercept = TRUE)
print(matrix_data)

}
