% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g.plots.R
\name{fan.plot}
\alias{fan.plot}
\title{Fan Plot Function}
\usage{
fan.plot(
  data,
  dist = "normal",
  lambda = NA,
  quantiles = c(0.05, 0.1, 0.25, 0.75, 0.9, 0.95),
  gradient = FALSE,
  ylimSuggest = c(NA, NA),
  ylimExpand = 0.1,
  newPlot = TRUE,
  boundColor = "blue",
  plotArgs = list(),
  actualArgs = list(),
  medianArgs = list(),
  polygonArgs = list(border = NA)
)
}
\arguments{
\item{data}{A matrix where columns represent the parameters of distributions.
E.g., for normal distribution, the columns will be \code{mean} and \code{variance}.
The first rows can be actual values given in the first column.}

\item{dist}{A string indicating the type of distribution. Currently, it can be either "normal" or "log-normal". Default is "normal".}

\item{lambda}{A numeric value for Box-Cox transformation. If \code{NA}, no transformation is applied. Default is \code{NULL}.}

\item{quantiles}{A numeric vector of quantiles for shading. Default is c(0.05, 0.1, 0.25, 0.75, 0.9, 0.95).}

\item{gradient}{A logical value indicating whether to create a gradient fan plot. If FALSE, a standard fan plot is created. Default is FALSE.}

\item{ylimSuggest}{A numeric vector of length 2 indicating the suggested y-axis limits. Use \code{NA} for automatic calculation. Default is c(NA, NA).}

\item{ylimExpand}{A numeric value indicating the proportion to expand the y-axis limits. Default is 0.1.}

\item{newPlot}{A logical value indicating whether to create a new plot. If FALSE, the fan plot is added to the existing plot. Default is TRUE.}

\item{boundColor}{A string indicating the color of the boundary of the fan plot. Default is "blue".}

\item{plotArgs}{A list of additional arguments passed to the plot function when creating a new plot.}

\item{actualArgs}{A list of additional arguments passed to the lines function when plotting actual values.}

\item{medianArgs}{A list of additional arguments passed to the lines function when plotting median values.}

\item{polygonArgs}{A list of additional arguments passed to the polygon function when creating the fan plot.}
}
\value{
This function does not return a value but creates a fan plot as a side effect.
}
\description{
This function creates a fan plot.
}
