% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get.indexation}
\alias{get.indexation}
\title{Get Numeric Indices in a Combination}
\usage{
get.indexation(combinations, data, isInnerExogenous)
}
\arguments{
\item{combinations}{A list returned by the \link{get.combinations} function.}

\item{data}{A list returned by \link{get.data} function.}

\item{isInnerExogenous}{Use \code{TRUE} if outer loop is defined over the endogenous variables and \code{FALSE} if it is for exogenous.}
}
\value{
A list similar to the input \code{combinations}, but with all character vectors in \code{innerGroups} or \code{partitions} converted to numeric vectors based on the index of the columns in the \code{data} matrix.
It sums the exogenous indexes with the number of endogenous variables and returns zero-based indexation for C code.
}
\description{
This function takes the output of the \link{get.combinations} function and a numeric matrix with given column names.
It converts all character vectors in \code{innerGroups} or \code{partitions} to numeric vectors based on the index of the columns.
}
