% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{search.varma}
\alias{search.varma}
\title{Create Model Set for VARMA Models}
\usage{
search.varma(
  data = get.data(),
  combinations = get.combinations(),
  metrics = get.search.metrics(),
  modelChecks = get.search.modelchecks(),
  items = get.search.items(),
  options = get.search.options(),
  maxParams = c(1, 0, 0, 0, 0, 0),
  seasonsCount = 0,
  maxHorizon = 1,
  simUsePreviousEstim = FALSE,
  olsStdMultiplier = 2,
  lbfgsOptions = get.options.lbfgs()
)
}
\arguments{
\item{data}{A list that determines data and other required information for the search process.
Use \code{\link[=get.data]{get.data()}} function to generate it from a \code{matrix} or a \code{data.frame}.}

\item{combinations}{A list that determines the combinations of endogenous and exogenous variables in the search process.
Use \code{\link[=get.combinations]{get.combinations()}} function to define it.}

\item{metrics}{A list of options for measuring performance. Use \link{get.search.metrics} function to get them.}

\item{modelChecks}{A list of options for excluding a subset of the model set. Use \link{get.search.modelchecks} function to get them.}

\item{items}{A list of options for specifying the purpose of the search. Use \link{get.search.items} function to get them.}

\item{options}{A list of extra options for performing the search. Use \link{get.search.options} function to get them.}

\item{maxParams}{An integer vector that determines the maximum values for the parameters of the VARMA model: \code{(p,d,q,P,D,Q)}. If \code{NULL}, \code{c(2,0,0,0,0,0)} is used.}

\item{seasonsCount}{An integer value representing the number of observations per unit of time.}

\item{maxHorizon}{An integer value representing the maximum value for the prediction horizon if \code{type1} is \code{TRUE} in the \code{modelChecks} argument. Also, it is used as the maximum prediction horizon in checking predictions.}

\item{simUsePreviousEstim}{If \code{TRUE}, parameters are initialized only in the first step of the simulation. The initial values of the n-th simulation (with one more observation) are the estimations from the previous step.}

\item{olsStdMultiplier}{A number used as a multiplier for the standard deviation of OLS, used for restricting maximum likelihood estimation.}

\item{lbfgsOptions}{A list containing L-BFGS optimization options. Use \link{get.options.lbfgs} function for initialization.}
}
\value{
A nested list with the following members:
\item{counts}{Information about the expected number of models, number of estimated models, failed estimations, and some details about the failures.}
\item{results}{A data frame with requested information in \code{items} list.}
\item{info}{The arguments and some general information about the search process such as the elapsed time.}

Note that the output does not contain any estimation results, but minimum required data to estimate the models (Use \code{summary()} function to get the estimation).
}
\description{
Use this function to create a Vector Autoregressive Moving Average model set and search for the best models (and other information) based on in-sample and out-of-sample evaluation metrics.
}
\examples{
# We simulate some data for this example:
set.seed(340)
n = 100
num_eq <- 3L
num_ar <- 2L
num_ma <- 1L
num_ma <- 1L
num_exo <- 2L
sample <- sim.varma(num_eq, arList = num_ar, maList = num_ma, exoCoef = num_exo, nObs = n)

# (relatively large) number of irrelevant explanatory variables:
num_y_ir <- 10
y_ir <- lapply(1:num_y_ir, function(x) rnorm(n))

# prepare data:
data <- data.frame(sample$y, y_ir, sample$x)
colnames(data) <- c(colnames(sample$y), paste0("w", 1:num_y_ir), colnames(sample$x))


# Create a VARMA model set:
y_sizes = 3 # assuming we know the number of relevant endogenous variables
metric_options <- get.search.metrics(typesIn = c("aic")) # We use SIC for searching
search_res <- search.varma(data = get.data(data, endogenous = num_eq + num_y_ir),
                           combinations = get.combinations(sizes = y_sizes,
                                                           numTargets = 3),
                           metrics = metric_options,
                           maxHorizon = 0)
print(search_res)


}
\seealso{
\link{estim.varma}
}
