% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer.R
\docType{class}
\name{layer}
\alias{layer}
\title{Leabra layer class}
\format{\code{\link{R6Class}} object}
\usage{
layer
}
\value{
Object of \code{\link{R6Class}} with methods for calculating changes
  of activation in a layer of neurons.
}
\description{
This class simulates a biologically realistic layer of neurons in the
Leabra framework. It consists of several \code{\link{unit}} objects
in the variable (field) \code{units} and some layer-specific
variables.
}
\section{Fields}{

\describe{
\item{\code{units}}{A list with all \code{\link{unit}} objects of the layer.}

\item{\code{avg_act}}{The average activation of all units in the layer
(this is an active binding).}

\item{\code{n}}{Number of units in layer.}

\item{\code{weights}}{A receiving x sending weight matrix, where the receiving units
(rows) has the current weight values for the sending units (columns). The
weights will be set by the \code{\link{network}} object, because they
depend on the connection to other layers.}

\item{\code{ce_weights}}{Sigmoidal contrast-enhanced version of the weight matrix
\code{weights}. These weights will be set by the \code{\link{network}}
object.}

\item{\code{layer_number}}{Layer number in network (this is 1 if you create
a layer on your own, without the network class).}
}}

\section{Methods}{

\describe{

  \item{\code{new(dim, g_i_gain = 2)}}{Creates an object of this class with
  default parameters.

    \describe{
      \item{\code{dim}}{A pair of numbers giving the dimensions (rows and
      columns) of the layer.}

      \item{\code{g_i_gain}}{Gain factor for inhibitory conductance, if you
      want less activation in a layer, set this higher.}
    }
  }

  \item{\code{get_unit_acts()}}{Returns a vector with the activations of all
  units of a layer.
  }

  \item{\code{get_unit_scaled_acts()}}{Returns a vector with the scaled
  activations of all units of a layer. Scaling is done with
  \code{recip_avg_act_n}, a reciprocal function of the number of active
  units.
  }

  \item{\code{cycle(intern_input, ext_input)}}{Iterates one time step with
  layer object.
    \describe{
       \item{\code{intern_input}}{Vector with inputs from all other layers.
       Each input has already been scaled by a reciprocal function of the
       number of active units (\code{recip_avg_act_n}) of the sending layer
       and by the connection strength between the receiving and sending
       layer. The weight matrix \code{ce_weights} is multiplied with this
       input vector to get the excitatory conductance for each unit in the
       layer.
       }

       \item{\code{ext_input}}{Vector with inputs not coming from another
       layer, with length equal to the number of units in this layer. If
       empty (\code{NULL}), no external inputs are processed. If the external
       inputs are not clamped, this is actually an excitatory conductance
       value, which is added to the conductance produced by the internal
       input and weight matrix.
       }
    }
  }

  \item{\code{clamp_cycle(activations)}}{Iterates one time step with layer
  object with clamped activations, meaning that activations are
  instantaneously set without time integration.

    \describe{
      \item{\code{activations}}{Activations you want to clamp to the units in
      the layer.
      }
    }
  }

  \item{\code{get_unit_act_avgs()}}{Returns a list with the short, medium and
  long term activation averages of all units in the layer as vectors. The
  super short term average is not returned, and the long term average is not
  updated before being returned (this is done in the function \code{chg_wt()}
  with the method\code{updt_unit_avg_l}). These averages are used by the
  network class to calculate weight changes.
  }

  \item{\code{updt_unit_avg_l()}}{Updates the long-term average
  (\code{avg_l}) of all units in the layer, usually done after a plus phase.
  }

  \item{\code{updt_recip_avg_act_n()}}{Updates the \code{avg_act_inert} and
  \code{recip_avg_act_n} variables, these variables update before the weights
  are changed instead of cycle by cycle. This version of the function assumes
  full connectivity between layers.
  }

  \item{\code{reset(random = FALSE)}}{Sets the activation and activation
  averages of all units to 0. Used to begin trials from a stationary point.

    \describe{
      \item{\code{random}}{Logical variable, if TRUE the activations are set
      randomly between .05 and .95 for every unit instead of 0.
      }
    }
  }

  \item{\code{set_ce_weights()}}{Sets contrast enhanced weight values.
  }

  \item{\code{get_unit_vars(show_dynamics = TRUE, show_constants =
  FALSE)}}{Returns a data frame with the current state of all unit variables
  in the layer. Every row is a unit. You can choose whether you want dynamic
  values and / or constant values. This might be useful if you want to
  analyze what happens in units of a layer, which would otherwise not be
  possible, because most of the variables (fields) are private in the unit
  class.
    \describe{
      \item{\code{show_dynamics}}{Should dynamic values be shown? Default is
      TRUE.
      }

      \item{\code{show_constants}}{Should constant values be shown? Default
      is FALSE.
      }
    }
  }

  \item{\code{get_layer_vars(show_dynamics = TRUE, show_constants =
  FALSE)}}{Returns a data frame with 1 row with the current state of the
  variables in the layer. You can choose whether you want dynamic values and
  / or constant values. This might be useful if you want to analyze what
  happens in a layer, which would otherwise not be possible, because some of
  the variables (fields) are private in the layer class.

    \describe{
      \item{\code{show_dynamics}}{Should dynamic values be shown? Default is
      TRUE.
      }

      \item{\code{show_constants}}{Should constant values be shown? Default
      is FALSE.
      }
    }
  }
}
}

\examples{
l <- layer$new(c(5, 5)) # create a 5 x 5 layer with default leabra values

l$g_e_avg # private values cannot be accessed
# if you want to see alle variables, you need to use the function
l$get_layer_vars(show_dynamics = TRUE, show_constants = TRUE)
# if you want to see a summary of all units without constant values
l$get_unit_vars(show_dynamics = TRUE, show_constants = FALSE)

# let us clamp the activation of the 25 units to some random values between
# 0.05 and 0.95
l <- layer$new(c(5, 5))
activations <- runif(25, 0.05, .95)
l$avg_act
l$clamp_cycle(activations)
l$avg_act
# what happened to the unit activations?
l$get_unit_acts()
# compare with activations
activations
# scaled activations are scaled by the average activation of the layer and
# should be smaller
l$get_unit_scaled_acts()

}
\references{
O'Reilly, R. C., Munakata, Y., Frank, M. J., Hazy, T. E., and
  Contributors (2016). Computational Cognitive Neuroscience. Wiki Book, 3rd
  (partial) Edition. URL: \url{http://ccnbook.colorado.edu}

Have also a look at
  \url{https://grey.colorado.edu/emergent/index.php/Leabra} (especially the
  link to the 'MATLAB' code) and \url{https://en.wikipedia.org/wiki/Leabra}
}
\keyword{data}
