% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactive.R
\name{addReactiveFeatures}
\alias{addReactiveFeatures}
\title{Add a reactive layer to map.}
\usage{
addReactiveFeatures(
  map,
  x,
  srcLayer,
  by,
  on,
  group,
  layerId = NULL,
  options = NULL,
  style = NULL,
  updateStyle = NULL,
  popup = NULL,
  ...
)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{x}{the (sf) features to be added to the map.}

\item{srcLayer}{the group name of the source layer that \code{x} should be bound to.}

\item{by}{shared attribute between \code{x} and \code{srcLayer} by which the
two layers should be bound together.}

\item{on}{the action to invoke the action. Can be one of "click" (default) and
"mouseover". The action will be triggered by holding Ctrl-key and performing \code{on}.}

\item{group}{the group name for the object to be added to \code{map}.}

\item{layerId}{the layerId.}

\item{options}{options to be passed to the layer.
See e.g. \code{\link[leaflet]{pathOptions}} for details.}

\item{style}{named list of styling instructions for the geometries in \code{x}.}

\item{updateStyle}{named list of how to update the styling of the \code{srcLayer}.}

\item{popup}{a character vector of the HTML content for the popups of layer \code{x}.
See \code{\link[leaflet]{addControl}} for details.}

\item{...}{currently not used.}
}
\description{
This function adds a layer to a map that is dependent on another layer.
  The reactive layer will be shown/hidden when holding the Ctrl-button on your
  keyboard and performing the action defined by \code{on}. \code{on} can be
  either "click" (default) or "mouseover".

  Note: \code{srcLayer} needs to be added to the map using \code{\link[leaflet]{addGeoJSON}}
  because we need to be able to link the two layers by a common attribute
  defined by argument \code{by}. Linking will be done via \code{group} name
  of \code{srcLayer}.
}
\examples{
library(leaflet)
library(leafem)
library(sf)
library(geojsonsf)

# create some random data
che = st_as_sf(gadmCHE)
pts = st_as_sf(st_sample(che, 200))
pts = st_join(pts, che[, "ID_1"])

che = sf_geojson(che)

leaflet() \%>\%
  addTiles() \%>\%
  addGeoJSON(che, group = "che") \%>\%
  addReactiveFeatures(
    pts
    , srcLayer = "che"
    , by = "ID_1"
    , on = "click"
    , group = "pts"
    , style = list(color = "black", fillOpacity = 0.3)
    , updateStyle = list(
      opacity = 0.3
      , fillOpacity = 0.3
      , color = "forestgreen"
      , fillColor = "forestgreen"
    )
  ) \%>\%
  addMouseCoordinates() \%>\%
  setView(lng = 8.31, lat = 46.75, zoom = 8)

}
