% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{addDrawToolbar}
\alias{addDrawToolbar}
\alias{removeDrawToolbar}
\title{Adds a Toolbar to draw shapes/points on the map.}
\usage{
addDrawToolbar(map, targetLayerId = NULL, targetGroup = NULL,
  position = c("topleft", "topright", "bottomleft", "bottomright"),
  polylineOptions = drawPolylineOptions(),
  polygonOptions = drawPolygonOptions(),
  circleOptions = drawCircleOptions(),
  rectangleOptions = drawRectangleOptions(),
  markerOptions = drawMarkerOptions(), editOptions = FALSE,
  singleFeature = FALSE)

removeDrawToolbar(map, clearFeatures = FALSE)
}
\arguments{
\item{map}{The map widget.}

\item{targetLayerId}{An optional layerId of a GeoJSON/TopoJSON layer whose features need to be editable.
Used for adding  a GeoJSON/TopoJSON layer and then editing the features using the draw plugin.}

\item{targetGroup}{An optional group name of a Feature Group whose features need to be editable.
Used for adding shapes(markers,lines,polygons) and then editing them using the draw plugin.
You can either set layerId or group or none but not both.}

\item{position}{The position where the toolbar should appear.}

\item{polylineOptions}{See \code{\link{drawPolylineOptions}}(). Set to FALSE to disable polyline drawing.}

\item{polygonOptions}{See \code{\link{drawPolygonOptions}}(). Set to FALSE to disable polygon drawing.}

\item{circleOptions}{See \code{\link{drawCircleOptions}}(). Set to FALSE to disable circle drawing.}

\item{rectangleOptions}{See \code{\link{drawRectangleOptions}}(). Set to FALSE to disable rectangle drawing.}

\item{markerOptions}{See \code{\link{drawMarkerOptions}}(). Set to FALSE to disable marker drawing.}

\item{editOptions}{By default editing is disable. To enable editing pass \code{\link{editToolbarOptions}}().}

\item{singleFeature}{When set to TRUE, only one feature can be drawn at a time, the previous ones being removed.}

\item{clearFeatures}{whether to clear the map of drawn features.}
}
\description{
Adds a Toolbar to draw shapes/points on the map.

Removes the draw toolbar
}
