% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{stablestage3.matrix}
\alias{stablestage3.matrix}
\title{Estimate Stable Stage Distribution for a Population Projection Matrix}
\usage{
\method{stablestage3}{matrix}(mats)
}
\arguments{
\item{mats}{A population projection matrix of class \code{matrix}.}
}
\value{
This function returns the stable stage distribution corresponding to
the input matrix. For square matrices with fewer than 400 rows, the stable stage
distribution is given as the right eigenvector associated with largest real part
of the eigenvalues estimated for the matrix via the \code{eig_gen}() function in
the C++ Armadillo library, divided by the sum of the associated right
eigenvector. For larger matrices, the matrix is assumed to be sparse and the
calculation is conducted similarly but using \code{eig_gens}() instead.
}
\description{
\code{stablestage3.matrix()} returns the stable stage distribution for a 
population projection matrix. This function can handle large and sparse
matrices, and so can be used with large historical matrices, IPMs, 
age x stage matrices, as well as smaller ahistorical matrices.
}
\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector, repstatus = repvector, 
                       obsstatus = obsvector, matstatus = matvector, immstatus = immvector, 
                       indataset = indataset, binhalfwidth = binvec, propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, patchidcol = "SUBPLOT", 
                         individcol = "GENET", blocksize = 9, juvcol = "Seedling1988", 
                         sizeacol = "Volume88", repstracol = "FCODE88", 
                         fecacol = "Intactseed88", deadacol = "Dead1988", 
                         nonobsacol = "Dormant1988", stageassign = lathframe, 
                         stagesize = "sizea", censorcol = "Missing1988", 
                         censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"), stage2 = c("Sd", "Sd", "Sd"), 
                       stage1 = c("Sd", "rep", "rep"), givenrate = c(0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = c(1989, 1990), 
                   stages = c("stage3", "stage2", "stage1"), repmatrix = lathrepm, 
                   overwrite = lathover3, yearcol = "year2", 
                   indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
stablestage3(ehrlen3mean$A[[1]])

}
\seealso{
\code{\link{stablestage3}()}

\code{\link{stablestage3.lefkoMat}()}
}
