% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{repvalue3.dgCMatrix}
\alias{repvalue3.dgCMatrix}
\title{Estimate Reproductive Value Vector for a Single Population Projection Matrix}
\usage{
\method{repvalue3}{dgCMatrix}(mats, ...)
}
\arguments{
\item{mats}{A population projection matrix.}

\item{...}{Other parameters.}
}
\value{
This function returns a vector data frame characterizing the 
reproductive values for stages of a population projection matrix. This is 
given as the left eigenvector associated with largest real part of the
dominant eigenvalue, divided by the first non-zero element of the left 
eigenvector.
}
\description{
\code{repvalue3.dgCMatrix()} returns the reproductive values for stages in a 
sparse population projection matrix. The function makes no assumptions about
whether the matrix is ahistorical and simply provides standard reproductive
values corresponding to each row, meaning that the overall reproductive
values of basic life history stages in a historical matrix are not provided
(the \code{\link{repvalue3.lefkoMat}()} function estimates these on the basis
of stage description information provided in the \code{lefkoMat} object used
as input in that function).
}
\section{Notes}{

Speed can sometimes be increased by shifting from automatic sparse matrix
determination to forced dense or sparse matrix projection. This will most
likely occur when matrices have several hundred rows and columns. Defaults
work best when matrices are very small and dense, or very large and sparse.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ", sparse_output = TRUE)

repvalue3(ehrlen3$A[[1]])

}
\seealso{
\code{\link{repvalue3}()}

\code{\link{repvalue3.lefkoMat}()}

\code{\link{repvalue3.matrix}()}

\code{\link{repvalue3.list}()}
}
