% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lmean}
\alias{lmean}
\title{Estimate Mean Projection Matrices}
\usage{
lmean(mats, matsout = NULL, force_sparse = FALSE)
}
\arguments{
\item{mats}{A \code{lefkoMat} object, or a list of square matrices of equal
dimension.}

\item{matsout}{A string identifying which means to estimate. Option
\code{"pop"} indicates population-level only, \code{"patch"} indicates
patch-level only, and \code{"all"} indicates that both patch- and
population-level means should be estimated. Defaults to \code{"all"}.}

\item{force_sparse}{A logical value identifying whether to output the mean
matrices in sparse format, if input as standard matrices.}
}
\value{
Yields a \code{lefkoMat} object with the following characteristics:

\item{A}{A list of full mean projection matrices in order of sorted
populations, patches, and years. These are typically estimated as the sums
of the associated mean \code{U} and \code{F} matrices. All matrices output
in either the \code{matrix} class, or the \code{dgCMatrix} class.}
\item{U}{A list of mean survival-transition matrices sorted as in \code{A}.
All matrices output in the \code{matrix} class.}
\item{F}{A list of mean fecundity matrices sorted as in \code{A}. All
matrices output in the \code{matrix} class.}
\item{hstages}{A data frame showing the pairing of ahistorical stages used
to create historical stage pairs. Given if the MPM is historical.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages.}
\item{labels}{A data frame detailing the order of population, patch, and
year of each mean matrix. If \code{pop}, \code{patch}, or \code{year2} are
\code{NA} in the original \code{labels} set, then these will be re-labeled
as \code{A}, \code{1}, or \code{1}, respectively.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} mean matrices, and the number of annual matrices.}
\item{modelqc}{This is the \code{qc} portion of the \code{modelsuite} input.
Only output from \code{lefkoMat} objects resulting from function-based
estimation.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input. Only output from \code{lefkoMat} objects
resulting from raw matrix estimation.}
}
\description{
Function \code{lmean()} estimates mean projection matrices as element-wise
arithmetic means. It produces \code{lefkoMat} objects if provided with them,
or single matrices in a simple one-element list if provided a list of
matrices.
}
\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cyp2mean <- lmean(cypmatrix2r)

}
