% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term.R
\name{term}
\alias{term}
\alias{legco_term}
\title{Term of LegCo}
\usage{
term(term_id = NULL, date = NULL, extra_param = NULL, verbose = TRUE)

legco_term(term_id = NULL, date = NULL, extra_param = NULL, verbose = TRUE)
}
\arguments{
\item{term_id}{the id of a term, or a vector of ids. If \code{NULL}, returns
results of all terms. Defaults to \code{NULL}.}

\item{date}{only fetch the result in which the specified date falls within.
Accepts character values in \code{"YYYY-MM-DD"} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}. Defaults
to \code{NULL}.}

\item{extra_param}{additional query parameters defined in LegCo API. Must
begin with \code{"&"}.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}
}
\description{
Fetch the basic information of LegCo terms.
}
\details{
This function corresponds to the \emph{Tterm} data endpoint of the Meeting
Schedule Database.
}
\section{Functions}{
 Functions of the Meeting Schedule Database: \itemize{
  \item \code{\link{term}}: LegCo terms \item \code{\link{session}}: LegCo
  sessions \item \code{\link{committee}}: LegCo committees \item
  \code{\link{membership}}: Membership of LegCo committees \item
  \code{\link{member}}: LegCo members \item \code{\link{member_term}}: Terms
  served by LegCo members \item \code{\link{meeting}}: Meetings of LegCo
  committees \item \code{\link{meeting_committee}}: Committees of LegCo
  meetings }
}

\examples{
\donttest{
# Fetch all LegCo terms
x <- term()
}

}
\seealso{
LegCo API documentation for the Meeting Schedule database:
  \url{https://www.legco.gov.hk/odata/english/attendance-db.html}
}
