% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-group.R
\name{key_group}
\alias{key_group}
\alias{key_group_split}
\alias{key_group_lut}
\title{Group keys}
\usage{
key_group_split(sep = "[^[:alnum:]]+", reverse = FALSE)

key_group_lut(members, group, ungrouped = "Other")
}
\arguments{
\item{sep}{A \verb{<character[1]>} giving a \link[base:regex]{regular expression} to
use for splitting labels provided by the scale using the
\code{\link[base:strsplit]{strsplit()}} function. By defaults, labels are splitted
on any non-alphanumeric character.}

\item{reverse}{A \verb{<logical[1]>} which if \code{FALSE} (default) treats the first
part of the split string as groups and later parts as members. If \code{TRUE},
treats the last part as groups.}

\item{members}{A vector including the scale's \code{breaks} values.}

\item{group}{A vector parallel to \code{members} giving  the group of each member.}

\item{ungrouped}{A \verb{<character[1]>} giving a group label to assign to the
scale's \code{breaks} that match no values in the \code{members} argument.}
}
\value{
A function to use as the \code{key} argument in a guide.
}
\description{
These functions are helper functions for working with grouped data as keys in
guides. They all share the goal of creating a guide key, but have different
methods.
\itemize{
\item \code{key_group_split()} is a function factory whose functions make an attempt
to infer groups from the scale's labels.
\item \code{key_group_lut()} is a function factory whose functions use a look up table
to sort out group membership.
}
}
\examples{
# Example scale
values <- c("group A:value 1", "group A:value 2", "group B:value 1")
template <- scale_colour_discrete(limits = values)

# Treat the 'group X' part as groups
key <- key_group_split(sep = ":")
key(template)

# Treat the 'value X' part as groups
key <- key_group_split(sep = ":", reverse = TRUE)
key(template)

# Example scale
template <- scale_colour_discrete(limits = msleep$name[c(1, 7, 9, 23, 24)])

# A lookup table can have more entries than needed
key <- key_group_lut(msleep$name, msleep$order)
key(template)

# Or less entries than needed
key <- key_group_lut(
  msleep$name[23:24], msleep$order[23:24],
  ungrouped = "Other animals"
)
key(template)
}
\seealso{
Other keys: 
\code{\link{key_range}},
\code{\link{key_specialty}},
\code{\link{key_standard}}
}
\concept{keys}
