% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-segments.R
\name{primitive_segments}
\alias{primitive_segments}
\title{Guide primitives: segments}
\usage{
primitive_segments(
  key = NULL,
  space = rel(10),
  vanish = FALSE,
  theme = NULL,
  position = waiver()
)
}
\arguments{
\item{key}{A \link[=key_segments]{segment key} specification. See more information
in the linked topic. Alternatively, an object of class
\code{\link[stats:hclust]{<hclust>}} that automatically invokes \code{key_dendro()}.}

\item{space}{Either a \code{\link[grid:unit]{<unit>}} or \code{\link[ggplot2:element]{<rel>}}
object of length 1 determining the space allocated in the orthogonal
direction. When the \code{space} argument is of class \verb{<rel>} (default) the
base size is taken from the tick length theme setting.}

\item{vanish}{Only relevant when the guide is used in the secondary theta
position: a \verb{<logical[1]>} on whether the continue to draw the segments
until they meed in the center (\code{TRUE}) or strictly observe the \code{space}
setting (\code{FALSE}).}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<PrimitiveSegments>} primitive guide that can be used inside other
guides.
}
\description{
This function constructs a \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
Below are the \link[ggplot2:theme]{theme} options that determine the style of
this guide, which may differ depending on whether the guide is used in an
axis or in a legend context.
\subsection{As an axis guide}{
\itemize{
\item \verb{axis.ticks.\{x/y\}.\{position\}} an \code{\link[ggplot2:element]{<element_line>}}
for display of the segments.
\item \verb{axis.ticks.length.\{x/y\}.\{position\}} a \code{\link[grid:unit]{<unit>}} for the
base size of the segments in the orthogonal direction.
}
}

\subsection{As a legend guide}{
\itemize{
\item \code{legend.ticks} an \code{\link[ggplot2:element]{<element_line>}} for display
of the segments.
\item \code{legend.ticks.length} a \code{\link[grid:unit]{<unit>}} for the
base size of the segments in the orthogonal direction.
}
}
}

\examples{
# Building a key
key <- key_segment_manual(
  value     = c(1.6, 1.6, 3.4, 5.2),
  value_end = c(7.0, 7.0, 3.4, 5.2),
  oppo      = c(1.0, 2.0, 0.0, 0.0),
  oppo_end  = c(1.0, 2.0, 3.0, 3.0)
)

# Using the primitive in a plot
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  scale_x_continuous(
    guide = primitive_segments(key = key)
  )
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_bracket}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_labels}()},
\code{\link{primitive_line}()},
\code{\link{primitive_spacer}()},
\code{\link{primitive_ticks}()},
\code{\link{primitive_title}()}
}
\concept{primitives}
