% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-sandwich.R
\name{compose_sandwich}
\alias{compose_sandwich}
\title{Compose guides as a sandwich}
\usage{
compose_sandwich(
  key = key_auto(),
  middle = gizmo_barcap(),
  text = "none",
  opposite = "none",
  args = list(),
  suppress_labels = "opposite",
  complete = TRUE,
  theme = NULL,
  theme_defaults = list(),
  reverse = FALSE,
  order = 0,
  title = waiver(),
  position = waiver(),
  available_aes = NULL
)
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. The key is shared
among all guides that have \code{NULL} keys themselves. See more information
in the linked topic.}

\item{middle}{Guide to use as the middle guide. Each guide can be specified
as one of the following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}}

\item{text, opposite}{Guides to use at the \code{legend.text.position} location
and on the opposite side of the \code{middle} guide respectively. Guide
specification is the same as in the \code{middle} argument.}

\item{args}{A \verb{<list>} of arguments to pass to guides that are given either
as a function or as a string.}

\item{suppress_labels}{A \verb{<character>} vector giving any of \code{"text"} and
\code{"opposite"} for the parallel guides. The guide(s) listed here will not
draw labels if they support a label suppression mechanism.}

\item{complete}{A \verb{<logical[1]>} whether to treat the composition as a
complete guide. If \code{TRUE}, a title and margin are added to the result.
If \code{FALSE} (default), no titles and margins are added.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide
individually of differently from the plot's theme settings. The \code{theme}
arguments in the guide overrides, and is combined with, the plot's theme.}

\item{theme_defaults}{A \verb{<list>} of theme elements to override undeclared
theme arguments.}

\item{reverse}{A \verb{<logical[1]>} whether to reverse continuous guides.
If \code{TRUE}, guides like colour bars are flipped. If \code{FALSE} (default),
the original order is maintained.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{position}{Where this guide should be drawn: one of \code{"top"}, \code{"bottom"},
\code{"left"}, or \code{"right"}.}

\item{available_aes}{A \verb{<character>} vector listing the aesthetics for which this guide can
be build.}
}
\value{
A \verb{<ComposeSandwich>} guide object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This guide composition has a middle guide flanked by two parallel guides.
}
\details{
The sandwich composition is effectively the same as a
\link[=compose_crux]{crux composition} lacking two opposing arms.
}
\examples{
# A standard plot with a sandwich guide
ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = cty)) +
  guides(colour = compose_sandwich(
    middle = "colourbar",
    text = "axis_base",
    opposite = primitive_bracket(key = key_range_manual(
      start = c(10, 20), end = c(25, 30), name = c("A", "B")
    ))
  ))
}
\seealso{
Other composition: 
\code{\link{compose_crux}()},
\code{\link{compose_ontop}()},
\code{\link{compose_stack}()},
\code{\link{guide-composition}}
}
\concept{composition}
