% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leptokurticMixture.R
\name{EM}
\alias{EM}
\title{EM for the finite mixtures of MLN}
\usage{
EM(
  data = NULL,
  G = 2,
  model = NULL,
  kml = c(1, 0, 1),
  n = 10,
  epsilon = 0.01,
  gpar0 = NULL,
  estimation = 1,
  label = NULL
)
}
\arguments{
\item{data}{A n x p matrix of observations.}

\item{G}{A integer determine the number of components of the mixture model.}

\item{model}{a character of length 4 such as "VVVV", indicating the model; the covariance and beta parameters. The 1st position controls, lambda, the volume; "V" varying across components or "E" equal across components. The 2nd position controls the eigenvalues; V" varying across components, "E" equal across components or "I" the identity matrix. The 3rd  position controls the orientation; "V" varying across components, "E" equal across components or "I" the identity matrix. The 4th position controls the concentration, beta; "V" varying across components, "E" equal across components, "F" fixed at the maximum value.}

\item{kml}{a vector of length 3 indicating, the number of k-means starts, number of random starts and the number of EM iterations used for each start}

\item{n}{The maximum number of EM iterations.}

\item{epsilon}{The tolerance for the stopping rule; lack of progress. The default is 1e-6 but it depends on the dataset.}

\item{gpar0}{A list of model parameters .}

\item{estimation}{If 1 (default)  use the fixed point iterations and if 2 the MM algorithm.}

\item{label}{If \code{NULL} then the data has no known groups. If \code{is.integer} then some of the observations have known groups. If \code{label[i]=k} then observation belongs to group  \code{k}. If \code{label[i]=0} then observation has no known group.}
}
\value{
A list with following items
\itemize{
  \item loglik - A vector of the loglikelihood values
  \item gpar - A list containing the parameters values
  \item z - A n x G matrix of the posterior probabilities
  \item map - A vector the maximum a posteriori derived from z
  \item label - The input provided. 
  \item numpar - The number of free parameters in the fitted model.
  \item maxLoglik - The largest value from loglik.
}
}
\description{
Performs a number of iterations of the EM for the multivariate elliptical leptokurtic-normal (MLN) distribution until the tolerance for the lack progress or the maximum number of iterations is reached. An implementation of parsimonious clustering models via the eigen-decomposition of the scatter matrix and allowing the concentration parameter to be varying, equal or fixed across components.
}
\examples{
x1 = rmln(n=100, d=4, mu=rep(5,4), diag(4), beta=2)
x2 = rmln(n=100, d=4, mu=rep(-5,4), diag(4), beta=2)
x = rbind( x1,x2)
mlnFit = EM(data=x, G=2, model="VVVF")
}
