% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizeSEMInternal.R
\name{.regularizeSEMInternal}
\alias{.regularizeSEMInternal}
\title{.regularizeSEMInternal}
\usage{
.regularizeSEMInternal(
  lavaanModel,
  penalty,
  weights,
  tuningParameters,
  method,
  modifyModel,
  control,
  notes = NULL
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{penalty}{string: name of the penalty used in the model}

\item{weights}{labeled vector with weights for each of the parameters in the
model.}

\item{tuningParameters}{data.frame with tuning parameter values}

\item{method}{which optimizer should be used? Currently implemented are ista
and glmnet. With ista, the control argument can be used to switch to related procedures
(currently gist).}

\item{modifyModel}{used to modify the lavaanModel. See ?modifyModel.}

\item{control}{used to control the optimizer. This element is generated with
the controlIsta() and controlGlmnet() functions.}

\item{notes}{option to pass a notes to function. All notes of the current
function will be added}
}
\value{
regularized SEM
}
\description{
Internal function: This function computes the regularized models
for all penaltiy functions which are implemented for glmnet and gist.
Use the dedicated penalty functions (e.g., lessSEM::lasso) to penalize
the model.
}
\keyword{internal}
