% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifyModel.R
\name{modifyModel}
\alias{modifyModel}
\title{modifyModel}
\usage{
modifyModel(
  addMeans = FALSE,
  activeSet = NULL,
  dataSet = NULL,
  transformations = NULL,
  transformationList = list(),
  transformationGradientStepSize = 1e-06
)
}
\arguments{
\item{addMeans}{If lavaanModel has meanstructure = FALSE, addMeans = TRUE will add a mean structure. FALSE will set the means of the observed variables to their observed means.}

\item{activeSet}{Option to only use a subset of the individuals in the data set. Logical vector of length N indicating which subjects should remain in the sample.}

\item{dataSet}{option to replace the data set in the lavaan model with a different data set. Can be useful for cross-validation}

\item{transformations}{allows for transformations of parameters - useful for measurement invariance tests etc.}

\item{transformationList}{optional list used within the transformations. NOTE: This must be used as an Rcpp::List.}

\item{transformationGradientStepSize}{step size used to compute the gradients of the
transformations}
}
\value{
Object of class modifyModel
}
\description{
Modify the model from lavaan to fit your needs
}
\examples{
modification <- modifyModel(addMeans = TRUE) # adds intercepts to a lavaan object
# that was fitted without explicit intercepts
}
