% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klfda.R
\name{klfda}
\alias{klfda}
\title{Kernel Local Fisher Discriminant Analysis for
Supervised Dimensionality Reduction}
\usage{
klfda(k, y, r, metric = c("weighted", "orthonormalized", "plain"), knn = 6,
  reg = 0.001)
}
\arguments{
\item{k}{n x n kernel matrix. Result of the \code{\link{kmatrixGauss}} function.
n is the number of samples}

\item{y}{n dimensional vector of class labels}

\item{r}{dimensionality of reduced space (default: d)}

\item{metric}{type of metric in the embedding space (default: 'weighted')
'weighted'        --- weighted eigenvectors
'orthonormalized' --- orthonormalized
'plain'           --- raw eigenvectors}

\item{knn}{parameter used in local scaling method (default: 6)}

\item{reg}{regularization parameter (default: 0.001)}
}
\value{
list of the LFDA results:
\item{T}{d x r transformation matrix (Z = t(T) * X)}
\item{Z}{r x n matrix of dimensionality reduced samples}
}
\description{
Performs kernel local fisher discriminant analysis on the given data,
which is the non-linear version of LFDA (see details \code{\link{lfda}}).
}
\examples{
\dontrun{
## example without dimension reduction
k <- kmatrixGauss(x = trainData[,-1])
y <- trainData[,1]
r <- 26 # dimensionality of reduced space. Here no dimension reduction is performed
result <- klfda(k,y,r,metric="plain")
transformedMat <- result$Z # transformed training data
metric.train <- as.data.frame(cbind(trainData[,1],transformedMat))
colnames(metric.train)=colnames(trainData)

## example with dimension reduction
k <- kmatrixGauss(x = trainData[,-1])
y <- trainData[,1]
r <- 3 # dimensionality of reduced space
result <- klfda(k,y,r,metric="plain")
transformMat  <- result$T # transforming matrix - distance metric

# transformed training data with Style
transformedMat <- result$Z # transformed training data
metric.train <- as.data.frame(cbind(trainData[,1],transformedMat))
colnames(metric.train)[1] <- "Style"

# transformed testing data with Style (unfinished)
metric.test <- kmatrixGauss(x = testData[,-1])
metric.test <- as.matrix(testData[,-1]) \%*\% transformMat
metric.test <- as.data.frame(cbind(testData[,1],metric.test))
colnames(metric.test)[1] <- "Style"

}

}
\author{
Yuan Tang
}
\references{
Sugiyama, M (2007). - contain implementation
Dimensionality reduction of multimodal labeled data by
local Fisher discriminant analysis.
\emph{Journal of Machine Learning Research}, vol.\bold{8}, 1027--1061.

Sugiyama, M (2006).
Local Fisher discriminant analysis for supervised dimensionality reduction.
In W. W. Cohen and A. Moore (Eds.), \emph{Proceedings of 23rd International
Conference on Machine Learning (ICML2006)}, 905--912.

Original Matlab Implementation: http://www.ms.k.u-tokyo.ac.jp/software.html#LFDA
}
\seealso{
See \code{\link{lfda}} for the linear version.
}
\keyword{discriminant}
\keyword{fisher}
\keyword{klfda}
\keyword{local}
\keyword{mahalanobis}
\keyword{metric}
\keyword{transformation}

