% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose}
\alias{compose}
\title{Composition of Fuzzy Relations}
\usage{
compose(
  x,
  y,
  e = NULL,
  alg = c("goedel", "goguen", "lukasiewicz"),
  type = c("basic", "sub", "super", "square"),
  quantifier = NULL,
  sorting = sort
)
}
\arguments{
\item{x}{A first fuzzy relation to be composed. It must be a numeric matrix
with values within the \eqn{[0,1]} interval. The number of columns must
match with the number of rows of the \code{y} matrix.}

\item{y}{A second fuzzy relation to be composed. It must be a numeric matrix
with values within the \eqn{[0,1]} interval. The number of columns must
match with the number of rows of the \code{x} matrix.}

\item{e}{Deprecated. An excluding fuzzy relation. If not NULL,
it must be a numeric matrix with dimensions equal to the \code{y} matrix.}

\item{alg}{An algebra to be used for composition. It must be one of
\code{'goedel'} (default), \code{'goguen'}, or \code{'lukasiewicz'}, or an instance of class \code{algebra}
(see \code{\link[=algebra]{algebra()}}).}

\item{type}{A type of a composition to be performed. It must be one of
\code{'basic'} (default), \code{'sub'}, \code{'super'}, or \code{'square'}.}

\item{quantifier}{Deprecated. If not NULL, it must be a function taking a single
argument, a vector of relative cardinalities, that would be translated into
membership degrees. A result of the \code{\link[=lingexpr]{lingexpr()}} function is a
good candidate for that. Note that the vector of relative cardinalities contains also
two attributes, \code{x} and \code{y}, which carry the original \code{R}'s data row (in \code{x}) and \code{S}'s
feature column (in \code{y}). These attributes are accessible using the standard \code{\link[base:attr]{base::attr()}}
function. Find examples below that define some quantifiers.}

\item{sorting}{Deprecated. Sorting function used within quantifier application. The given function
must sort the membership degrees and allow the \code{decreasing} argument as in \code{\link[base:sort]{base::sort()}}.
This function have to be explicitly specified typically if performing compositions that
handle \code{NA} values.}
}
\value{
A matrix with \eqn{v} rows and \eqn{w} columns, where \eqn{v} is the
number of rows of \code{x} and \eqn{w} is the number of columns of \code{y}.
}
\description{
Composition of Fuzzy Relations
}
\details{
Function composes a fuzzy relation \code{x} (i.e. a numeric matrix of size
\eqn{(u,v)}) with a fuzzy relation \code{y} (i.e. a numeric matrix of size
\eqn{(v,w)}) and possibly with the deprecated use of an exclusion fuzzy relation
\code{e} (i.e. a numeric matrix of size \eqn{(v,w)}).

The style of composition is determined by the algebra \code{alg}, the
composition type \code{type}, and possibly also by a deprecated \code{quantifier}.

This function performs four main composition types, the basic composition (
also known as direct product), the Bandler-Kohout subproduct (also subdirect
product), the Bandler-Kohout superproduct (also supdirect product), and finally,
the Bandler-Kohout square product. More complicated composition operations
may be performed by using the \code{\link[=mult]{mult()}} function and/or by combining multiple
composition results with the \code{\link[=algebra]{algebra()}} operations.
}
\examples{
    R <- matrix(c(0.1, 0.6, 1, 0, 0, 0,
                  0, 0.3, 0.7, 0.9, 1, 1,
                  0, 0, 0.6, 0.8, 1, 0,
                  0, 1, 0.5, 0, 0, 0,
                  0, 0, 1, 1, 0, 0), byrow=TRUE, nrow=5)

    S <- matrix(c(0.9, 1, 0.9, 1,
                  1, 1, 1, 1,
                  0.1, 0.2, 0, 0.2,
                  0, 0, 0, 0,
                  0.7, 0.6, 0.5, 0.4,
                  1, 0.9, 0.7, 0.6), byrow=TRUE, nrow=6)

    RS <- matrix(c(0.6, 0.6, 0.6, 0.6,
                   1, 0.9, 0.7, 0.6,
                   0.7, 0.6, 0.5, 0.4,
                   1, 1, 1, 1,
                   0.1, 0.2, 0, 0.2), byrow=TRUE, nrow=5)

    compose(R, S, alg='goedel', type='basic') # should be equal to RS
}
\seealso{
[algebra(), \code{\link[=mult]{mult()}}, \code{\link[=lingexpr]{lingexpr()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{multivariate}
\keyword{robust}
