% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geometryHandling.R
\name{getpolyol}
\alias{getpolyol}
\title{getpolyol function}
\usage{
getpolyol(data, regionalcovariates = NULL, pixelcovariates = NULL,
  cellwidth, ext = 2, inclusion = "touching")
}
\arguments{
\item{data}{an object of class ppp or SpatialPolygonsDataFrame, containing the event counts, i.e. the dataset that will eventually be analysed}

\item{regionalcovariates}{an object of class SpatialPolygonsDataFrame containng regionally measured covariate information}

\item{pixelcovariates}{X an object of class SpatialPixelsDataFrame containng regionally measured covariate information}

\item{cellwidth}{the chosen cell width}

\item{ext}{the amount by which to extend the observation window in forming the FFT grid, default is 2. In the case that the point pattern has long range spatial correlation, this may need to be increased.}

\item{inclusion}{criterion for cells being included into observation window. Either 'touching' or 'centroid'. The former, the default, includes all cells that touch the observation window, the latter includes all cells whose centroids are inside the observation window.}
}
\value{
an object of class lgcppolyol, which can then be fed into the function getZmat.
}
\description{
A function to perform polygon/polygon overlay operations and form the computational grid, on which inference will eventually take place.
For details and examples of using this fucntion, please see the package vignette "Bayesian_lgcp"
}
\seealso{
\link{minimum.contrast}, \link{minimum.contrast.spatiotemporal}, \link{chooseCellwidth}, \link{guessinterp}, \link{getZmat},
\link{addTemporalCovariates}, \link{lgcpPrior}, \link{lgcpInits}, \link{CovFunction}
\link{lgcpPredictSpatialPlusPars}, \link{lgcpPredictAggregateSpatialPlusPars}, \link{lgcpPredictSpatioTemporalPlusPars},
\link{lgcpPredictMultitypeSpatialPlusPars}
}

