\name{rgauss}
\alias{rgauss}
\title{rgauss function}
\usage{
rgauss(n = 1, range = c(0, 1), ncells = 128,
  spatial.covmodel = "exponential", model.parameters = lgcppars(sigma = 2,
  phi = 0.1), covpars = c(), ext = 2)
}
\arguments{
  \item{n}{the number of realisations to generate. Default
  is 1.}

  \item{range}{a vector of length 2, defining the left-most
  and right most cell centroids in the x-direction. Note
  that the centroids in the y-direction are the same as
  those in the x-direction.}

  \item{ncells}{the number of cells, typially a power of 2}

  \item{spatial.covmodel}{spatial covariance function,
  default is exponential, see ?CovarianceFct}

  \item{model.parameters}{parameters of model, see
  ?lgcppars. Only set sigma and phi for spatial model.}

  \item{covpars}{vector of additional parameters for
  spatial covariance function, in order they appear in
  chosen model in ?CovarianceFct}

  \item{ext}{how much to extend the parameter space by.
  Default is 2.}
}
\value{
an lgcp grid object containing the simulated field(s).
}
\description{
A function to simulate a Gaussian field on a regular square
lattice, the returned object is of class lgcpgrid.
}

