% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lgcpStructures.R
\name{condProbs}
\alias{condProbs}
\title{condProbs function}
\usage{
condProbs(obj)
}
\arguments{
\item{obj}{an lgcpPredictMultitypeSpatialPlusParameters object}
}
\value{
an lgcpgrid object containing the consitional type-probabilities for each type
}
\description{
A function to compute the conditional type-probabilities from a multivariate LGCP. See the vignette "Bayesian_lgcp" for a full explanation of this.\cr
}
\details{
We suppose there are K point types of interest. The model for point-type k is as follows:\cr
\cr
X_k(s) ~ Poisson[R_k(s)]\cr
\cr
R_k(s) = C_A lambda_k(s) exp[Z_k(s)beta_k+Y_k(s)]\cr
\cr

Here X_k(s) is the number of events of type k in the computational grid cell containing the
point s, R_k(s) is the Poisson rate, C_A is the cell area, lambda_k(s) is a known offset, Z_k(s) is a vector
of measured covariates and Y_i(s) where i = 1,...,K+1 are latent Gaussian processes on the
computational grid. The other parameters in the model are beta_k , the covariate effects for the
kth type; and eta_i = [log(sigma_i),log(phi_i)], the parameters of the process Y_i for i = 1,...,K+1 on
an appropriately transformed (again, in this case log) scale.

The term 'conditional probability of type k' means the probability that at a particular location there
will be an event of type k, which denoted p_k.
}
\seealso{
\link{segProbs}, \link{postcov.lgcpPredictSpatialOnlyPlusParameters}, \link{postcov.lgcpPredictAggregateSpatialPlusParameters}, \link{postcov.lgcpPredictSpatioTemporalPlusParameters}, \link{postcov.lgcpPredictMultitypeSpatialPlusParameters},
\link{ltar}, \link{autocorr}, \link{parautocorr}, \link{traceplots}, \link{parsummary}, \link{textsummary},
\link{priorpost}, \link{postcov}, \link{exceedProbs}, \link{betavals}, \link{etavals}
}

