% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R, R/methods-Prediction.R
\docType{class}
\name{Prediction-class}
\alias{Prediction-class}
\alias{Prediction}
\alias{show,Prediction-method}
\alias{component_names,Prediction-method}
\alias{num_components,Prediction-method}
\alias{num_paramsets,Prediction-method}
\alias{num_evalpoints,Prediction-method}
\title{An S4 class to represent prior or posterior
draws from an additive function distribution.}
\usage{
\S4method{show}{Prediction}(object)

\S4method{component_names}{Prediction}(object)

\S4method{num_components}{Prediction}(object)

\S4method{num_paramsets}{Prediction}(object)

\S4method{num_evalpoints}{Prediction}(object)
}
\arguments{
\item{object}{\linkS4class{Prediction} object for which to apply a class
method.}
}
\description{
An S4 class to represent prior or posterior
draws from an additive function distribution.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Print a summary about the object.

\item \code{component_names}: Get names of components.

\item \code{num_components}: Get number of components.

\item \code{num_paramsets}: Get number of parameter combinations
(different parameter vectors) using which predictions were computed.

\item \code{num_evalpoints}: Get number of points where
predictions were computed.
}}

\section{Slots}{

\describe{
\item{\code{f_comp}}{component draws}

\item{\code{f}}{signal draws}

\item{\code{h}}{predictions (signal draws + scaling factor \code{c_hat},
transformed through inverse link function)}

\item{\code{x}}{a data frame of points (covariate values) where the
functions/predictions have been evaluated/sampled}

\item{\code{extrapolated}}{Boolean value telling if the function draws are
original MCMC draws or if they have been created by extrapolating
such draws.}
}}

\seealso{
\linkS4class{GaussianPrediction}
}
