% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogEvent.R
\name{as.data.frame.LogEvent}
\alias{as.data.frame.LogEvent}
\alias{as.data.table.LogEvent}
\alias{as_tibble.LogEvent}
\title{Coerce LogEvents to Data Frames}
\usage{
\method{as.data.frame}{LogEvent}(x, row.names = NULL, optional = FALSE,
  stringsAsFactors = FALSE, ...)

as.data.table.LogEvent(x, ...)

as_tibble.LogEvent(x, ...)
}
\arguments{
\item{x}{any \R object.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{currently ignored and only included for compatibility.}

\item{stringsAsFactors}{\code{logical} scalar: should \code{character} vectors be
converted to factors? Defaults to \code{FALSE} (as opposed to
\code{\link[base:as.data.frame]{base::as.data.frame()}}) and is only included for compatibility.}

\item{...}{passed on to \code{data.frame()}}
}
\description{
Coerce LogEvents to \code{data.frames}, \code{\link[data.table:data.table]{data.tables}},
or \code{\link[tibble:tibble]{tibbles}}.
}
\examples{
lg <- get_logger("test")
lg$info("lorem ipsum")
as.data.frame(lg$last_event)

lg$info("LogEvents can store any custom log values", df = iris)
as.data.frame(lg$last_event)
head(as.data.frame(lg$last_event)$df[[1]])
}
\seealso{
\link[data.table:data.table]{data.table::data.table}, \link[tibble:tibble]{tibble::tibble}
}
