% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{is_valid_isbn_13}
\alias{is_valid_isbn_13}
\title{Return TRUE if valid ISBN 13}
\usage{
is_valid_isbn_13(x, allow.hyphens = TRUE)
}
\arguments{
\item{x}{A string of 13}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed
(default is \code{TRUE})}
}
\value{
Returns TRUE if checks pass, FALSE if not, and NA if NA
}
\description{
Takes a string representation of an ISBN 13 verifies that it is valid.
An ISBN 13 is valid if it is a 13 digit string and the check digit matches
}
\examples{

is_valid_isbn_13("9780306406157")          # TRUE
is_valid_isbn_13("978-0-306-40615-7")      # TRUE

# vectorized
is_valid_isbn_10(c("012491540X", "9004037812"))  # TRUE FALSE
is_valid_isbn_13(c("978-0-306-40615-7", "9783161484103"))  # TRUE FALSE
is_valid_isbn_13(c("978-0-306-40615-7", "hubo un tiempo"))  # TRUE FALSE

}
